from django.shortcuts import render, redirect
from .models import MenuItem, Bill, BillItem
from .forms import BillForm, BillItemForm

def home(request):
    return render(request, 'billing/home.html')

def create_bill(request):
    bill_form = BillForm()
    item_form = BillItemForm()
    if request.method == 'POST':
        bill_form = BillForm(request.POST)
        item_form = BillItemForm(request.POST)
        if bill_form.is_valid() and item_form.is_valid():
            bill = bill_form.save()
            item = item_form.cleaned_data['item']
            quantity = item_form.cleaned_data['quantity']
            BillItem.objects.create(bill=bill, item=item, quantity=quantity, subtotal=item.price*quantity)
            bill.total_amount = item.price * quantity
            bill.save()
            return redirect('bill_detail', bill.id)
    return render(request, 'billing/create_bill.html', {'bill_form': bill_form, 'item_form': item_form})

def bill_detail(request, bill_id):
    bill = Bill.objects.get(id=bill_id)
    return render(request, 'billing/bill_detail.html', {'bill': bill})


from django.template.loader import render_to_string
from django.http import HttpResponse
from xhtml2pdf import pisa
import datetime

def download_pdf(request, bill_id):
    bill = Bill.objects.get(id=bill_id)

    template_path = 'billing/pdf_template.html'
    context = {'bill': bill}

    html = render_to_string(template_path, context)
    response = HttpResponse(content_type='application/pdf')
    response['Content-Disposition'] = f'attachment; filename="bill_{bill_id}.pdf"'

    pisa_status = pisa.CreatePDF(html, dest=response)

    if pisa_status.err:
        return HttpResponse('PDF generation failed!')
    return response
